/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.log;

import io.gitlab.jfronny.commons.logger.CompactLogger;
import io.gitlab.jfronny.commons.logger.impl.Formatter;
import java.util.Objects;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LoggingEventBuilder;

public class SLF4JPlatformLogger
implements CompactLogger {
    private static final String PRESUMED_CALLER_BOUNDARY = System.Logger.class.getName();
    private final Logger slf4jLogger;

    public SLF4JPlatformLogger(Logger logger) {
        this.slf4jLogger = Objects.requireNonNull(logger);
    }

    @Override
    public String getName() {
        return this.slf4jLogger.getName();
    }

    @Override
    public System.Logger.Level getLevel() {
        if (this.slf4jLogger.isTraceEnabled()) {
            return System.Logger.Level.TRACE;
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            return System.Logger.Level.DEBUG;
        }
        if (this.slf4jLogger.isInfoEnabled()) {
            return System.Logger.Level.INFO;
        }
        if (this.slf4jLogger.isWarnEnabled()) {
            return System.Logger.Level.WARNING;
        }
        if (this.slf4jLogger.isErrorEnabled()) {
            return System.Logger.Level.ERROR;
        }
        return System.Logger.Level.INFO;
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        if (level == System.Logger.Level.ALL) {
            return true;
        }
        if (level == System.Logger.Level.OFF) {
            return false;
        }
        return this.slf4jLogger.isEnabledForLevel(this.jplLevelToSLF4JLevel(level));
    }

    private Level jplLevelToSLF4JLevel(System.Logger.Level jplLevel) {
        return switch (jplLevel) {
            case System.Logger.Level.TRACE -> Level.TRACE;
            case System.Logger.Level.DEBUG -> Level.DEBUG;
            case System.Logger.Level.INFO -> Level.INFO;
            case System.Logger.Level.WARNING -> Level.WARN;
            case System.Logger.Level.ERROR -> Level.ERROR;
            default -> Level.INFO;
        };
    }

    @Override
    public void log(System.Logger.Level level, String message) {
        this.log(level, null, message, null, null);
    }

    @Override
    public void log(System.Logger.Level level, String message, Throwable throwable) {
        this.log(level, null, message, throwable, null);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, bundle, msg, thrown, null);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object[] params) {
        this.log(level, bundle, format, null, params);
    }

    @Override
    public void log(System.Logger.Level jplLevel, ResourceBundle bundle, String msg, Throwable thrown, Object[] params) {
        if (jplLevel == System.Logger.Level.OFF) {
            return;
        }
        if (jplLevel == System.Logger.Level.ALL) {
            this.performLog(Level.TRACE, bundle, msg, thrown, params);
            return;
        }
        Level slf4jLevel = this.jplLevelToSLF4JLevel(jplLevel);
        if (this.slf4jLogger.isEnabledForLevel(slf4jLevel)) {
            this.performLog(slf4jLevel, bundle, msg, thrown, params);
        }
    }

    private void performLog(Level slf4jLevel, ResourceBundle bundle, String msg, Throwable thrown, Object[] params) {
        String message = Formatter.getResourceStringOrMessage(bundle, msg);
        LoggingEventBuilder leb = this.slf4jLogger.makeLoggingEventBuilder(slf4jLevel);
        if (thrown != null) {
            leb = leb.setCause(thrown);
        }
        if (params != null && params.length > 0) {
            for (Object param : params) {
                leb = leb.addArgument(param);
            }
            message = Formatter.format(bundle, msg, params);
        }
        if (leb instanceof CallerBoundaryAware) {
            CallerBoundaryAware cba = (CallerBoundaryAware)leb;
            cba.setCallerBoundary(PRESUMED_CALLER_BOUNDARY);
        }
        leb.log(message);
    }
}

